/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.init;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.debuffs.sources.DebuffSourceType;
import dev.toma.gunsrpg.common.debuffs.sources.EntityMeleeDamageSource;
import dev.toma.gunsrpg.common.debuffs.sources.ExplosionConstantDamageSource;
import dev.toma.gunsrpg.common.debuffs.sources.ExplosionDamageSource;
import dev.toma.gunsrpg.common.debuffs.sources.FallConstantDamageSource;
import dev.toma.gunsrpg.common.debuffs.sources.FallDamageSource;
import dev.toma.gunsrpg.common.debuffs.sources.HurtByEntitySource;
import dev.toma.gunsrpg.common.debuffs.sources.HurtBySlimeSource;
import dev.toma.gunsrpg.common.debuffs.sources.WeaponDamageSource;
import dev.toma.gunsrpg.common.init.ModRegistries;

public final class ModDebuffSources {
    public static final DebuffSourceType<HurtByEntitySource> HURT_BY_ENTITY = new DebuffSourceType<HurtByEntitySource>(GunsRPG.makeResource("hurt_by_entity"), HurtByEntitySource.CODEC);
    public static final DebuffSourceType<HurtBySlimeSource> HURT_BY_SLIME = new DebuffSourceType<HurtBySlimeSource>(GunsRPG.makeResource("hurt_by_slime"), HurtBySlimeSource.CODEC);
    public static final DebuffSourceType<EntityMeleeDamageSource> ENTITY_MELEE_DAMAGE = new DebuffSourceType<EntityMeleeDamageSource>(GunsRPG.makeResource("entity_melee_damage"), EntityMeleeDamageSource.CODEC);
    public static final DebuffSourceType<ExplosionDamageSource> EXPLOSION_DAMAGE = new DebuffSourceType<ExplosionDamageSource>(GunsRPG.makeResource("explosion_damage"), ExplosionDamageSource.CODEC);
    public static final DebuffSourceType<ExplosionConstantDamageSource> EXPLOSION_DAMAGE_CONSTANT = new DebuffSourceType<ExplosionConstantDamageSource>(GunsRPG.makeResource("explosion_damage_constant"), ExplosionConstantDamageSource.CODEC);
    public static final DebuffSourceType<FallDamageSource> FALL_DAMAGE = new DebuffSourceType<FallDamageSource>(GunsRPG.makeResource("fall_damage"), FallDamageSource.CODEC);
    public static final DebuffSourceType<FallConstantDamageSource> FALL_DAMAGE_CONSTANT = new DebuffSourceType<FallConstantDamageSource>(GunsRPG.makeResource("fall_damage_constant"), FallConstantDamageSource.CODEC);
    public static final DebuffSourceType<WeaponDamageSource> WEAPON_DAMAGE = new DebuffSourceType<WeaponDamageSource>(GunsRPG.makeResource("weapon_damage"), WeaponDamageSource.CODEC);

    public static void register() {
        ModDebuffSources.register(HURT_BY_ENTITY);
        ModDebuffSources.register(HURT_BY_SLIME);
        ModDebuffSources.register(ENTITY_MELEE_DAMAGE);
        ModDebuffSources.register(EXPLOSION_DAMAGE);
        ModDebuffSources.register(EXPLOSION_DAMAGE_CONSTANT);
        ModDebuffSources.register(FALL_DAMAGE);
        ModDebuffSources.register(FALL_DAMAGE_CONSTANT);
        ModDebuffSources.register(WEAPON_DAMAGE);
    }

    private static void register(DebuffSourceType<?> type) {
        ModRegistries.DEBUFF_SOURCE_TYPES.register(type);
    }
}

